""" GET CLIENT IP ADDRESS """
def get_user_ip(request):
    x_forwarded_for = request.META.get('HTTP_X_FORWARDED_FOR')

    if x_forwarded_for:
        user_ip = x_forwarded_for.split(',')[0]
    else:
        user_ip = request.META.get('REMOTE_ADDR')

    return user_ip



""" FORM ERROR FORMATTER """
def form_error_formatter(form_err={}):
    errors_str = ''
    for field, errors in dict(form_err).items():
        for error in errors:
            errors_str += f' {field.replace("_", " ").capitalize()} | {error},'
    return errors_str