from rest_framework import serializers
from jobs.models import Job, Company, JobUpdates, FilesModel

class CompanySerializer(serializers.ModelSerializer):
    class Meta:
        model = Company
        fields = ['id', 'name', 'description', 'website', 'get_image_url', 'meta_data', 'get_image', 'get_thumbnail']


class JobUpdatesCreateSerializer(serializers.Serializer):
    class Meta:
        model = JobUpdates
        fields = ['id', 'from_action', 'to_action', 'update', 'datetime_created']

class JobFileSerializer(serializers.ModelSerializer):
    class Meta:
        model = FilesModel
        fields = "__all__"


class JobSerializer(serializers.ModelSerializer):
    company = CompanySerializer()  # Include company details in the job serializer
    update = JobUpdatesCreateSerializer(many=True)
    files = JobFileSerializer(many=True)

    class Meta:
        model = Job
        fields = ['id', 'title', 'description', 'link', 'company', 'status', 'datetime_created', 'update', 'files']


class UpdateJobSerializer(serializers.ModelSerializer):
    class Meta:
        model = Job
        fields = ['id', 'title', 'description', 'company', 'status',]
    

