from django.urls import path
from jobs import views


urlpatterns = [
    path('jobs/', views.job_list_create, name='job-list-create'),
    path('jobs/<int:pk>/', views.job_update_delete_detail, name='job_update_delete_detail'),

    path('companies/', views.CompanyListCreate.as_view(), name='company-list-create'),
    path('companies/<int:pk>/', views.CompanyDetailView.as_view(), name='company-detail-view'),
    path('companies/company-search/', views.company_search, name='company_search'),

    path('job-update/<int:job_pk>/', views.job_update_list, name='job_update_list'),
    path('job-update/<int:pk>/', views.job_update_detail, name='job_update_detail'),

]